#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KA_SP_J						65
#define KAZ_KA_SP_SL					128

#define KAZ_KA_SP_N						"9680693320350411581735712527156160041331448806285781880953481207107506184928318589548473667621840334803765737814574120142199988285"
#define KAZ_KA_SP_LN					432 // in binary (54 bytes)

#define KAZ_KA_SP_g1					"65563"
#define KAZ_KA_SP_g2					"65617"

#define KAZ_KA_SP_Og1N					"277591565561588714832683121976613472000"
#define KAZ_KA_SP_LOg1N					128 // in binary (17 bytes)
#define KAZ_KA_SP_Og2N					"832774696684766144498049365929840416000"
#define KAZ_KA_SP_LOg2N					130 // in binary (17 bytes)

#define KAZ_KA_PUBLICKEY_BYTES			54 // in bytes for each A1, A2
#define KAZ_KA_PRIVATEKEY_BYTES			17 // in bytes for each a1, a2

#define KAZ_KA_SHAREDKEY_BYTES			54 // in bytes for shared key

extern void init_random();
extern void clear_random();
extern void KAZ_KA_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KA_KEYGEN(unsigned char *kaz_ka_public_key, 
                         unsigned char *kaz_ka_private_key, 
                         const unsigned char *kaz_ka_types);

extern int KAZ_KEY_AGREEMENT(unsigned char *sharedkey, 
                             const unsigned char *kaz_ka_public_key_slave, 
                             const unsigned char *kaz_ka_private_key_primary);

#endif // FILE_H_INCLUDED
